<?php
$id=$_GET["id"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Details</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
	<!-- CSS -->


<link rel="stylesheet" type="text/css" href="vendors/styles/core.css">
	<link rel="stylesheet" type="text/css" href="vendors/styles/icon-font.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/dataTables.bootstrap4.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/responsive.bootstrap4.min.css">
	
		<link rel="stylesheet" type="text/css" href="vendors/styles/style.css">  
        <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Aldrich&family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Noto+Sans+Devanagari:wght@100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: white;
            font-family: Arial, sans-serif;
        }
        .container {
            background: #fff;
            position: fixed;
            padding: 10px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            margin-top: 0;
            margin-left: 0;
            margin-right: 0;
        }
        .header1 {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 48px;
        }
        .header1 .icons i {
            font-size: 20px;
            cursor: pointer;
        }
        .customer-name {
            text-align: center;
            font-size: 20px;
            font-weight: 500;
            color: #000;
            padding: 80px 20px 20px 20px;
        }
        .contact-info {
            display: flex;
            justify-content: space-evenly;
            align-items: center;
            gap: 10px;
            margin-top: 5px;
        }
        .contact-info a {
            text-decoration: none;
            color: #253ED6;
            font-weight: 500;
            display: flex;
            align-items: center;
        }
        .contact-info i {
            color: green;
        }

        .contact-info span {
            font-size: 16px;
            font-weight: 500;
            margin-bottom: -4px;
        }

        .stats {
        display: grid;
        grid-template-columns: repeat(2, 1fr); /* Two columns */
        gap: 10px; /* Space between cards */
        padding: 20px 15px 0px 15px;
    }
    .stat-card {
        border-radius: 10px;
        border: 1px solid #D9D9D9;
        padding: 10px;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        gap: 10px;
    }
    .stat-card i {
        font-size: 22px;
        width: 40px; 
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        background: #ddd;
    }
    .stat-text {
        display: flex;
        flex-direction: column;
        font-size: 14px;
    }

    .stat-text div {
        font-size: 15px;
        font-weight: 400;
        color: #000;
    }
    .stat-text small, 
    .address-section h6,
    .address-text div,
    .address-text h6 {
        font-size: 16px;
        font-weight: 400;
        color: #000;
    }

        .address-section {
            margin-top: 15px;
        }
        .address-card {
            border-radius: 10px;
            padding: 20px;
            border: 1px solid #D9D9D9;
            margin-top: 15px;
            display: flex;
            /* align-items: center; */
        }
        .address-card i {
            color: blue;
            font-size: 22px;
        width: 40px;
        height: 40px;
        /* display: flex;
        align-items:center;
        justify-content: center; */
        /* margin-top: -45px; */
        }
        .addresspart{
            margin-left: 15px;
            margin-right: 15px;
            margin-top: 35px;
        }
   
    .address-text {
        display: flex;
        flex-direction: column;
        font-size: 14px;
        line-height: 1.5;
    }

    .icon-cust {
        padding: 15px;
    }

    .fa-arrow-left {
        font-size: 24px;
    }

    .icon-cust i,
    .icon-cust img {
        font-size: 26px;
    }

    .header1 div span {
        font-size: 18px;
        color: #000;
        font-weight: 500;
    }

    .img-icon {
        background: #FDE6EA;
        border-radius: 10px;
        width: 40px;
        height: 40px;
        align-items: center;
        justify-content: center;
        display: flex;
    }

    .img-icon img {
        width: 27px;
        height: 27px;
    }


    .stat-card:active {
        box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
    }
    @media (max-width: 480px) {
    body, h1, h2, h3, h4, h5, h6, .h4, .h5, .page-header h4 {
        font-family: "Noto Sans Devanagari", serif !important;
        font-weight: normal ;
    }
}
.modal {
    display: none;
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
}
.modal-content {
    background: white;
    padding: 20px;
    margin: 15% auto;
    width: 300px;
    text-align: center;
}
button {
    margin: 10px;
    padding: 5px 10px;
    cursor: pointer;
}

.stat-text small {
    display: inline-block;
    max-width: 100px; /* Adjust based on your layout */
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    position: relative;
}

.stat-text small:hover::after {
    content: "Purchase Orders";
    position: absolute;
    white-space: nowrap;
    background-color: rgba(0, 0, 0, 0.8);
    color: #fff;
    padding: 5px;
    left: 0;
    top: 100%;
    z-index: 10;
}

    </style>
</head>
<body>

<div class="container">
    <!-- Header1 Section -->
    <div class="header1">
        <div class="d-flex">
            <a href="customer.php"><i class="fas fa-arrow-left"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;<span>Details</span>
        </div>
        <div class="d-flex">
            <div class="icon-cust">
                <a href="editcust.php?id=<?php echo$id?>">
                    <img src="images/ic_outline-edit.png" alt="">
                </a>
            </div>
            <div class="icon-cust">
                <img src="images/ic_baseline-delete.png" alt="Delete" class="delete-btn" data-id="<?php echo$id?>">
            </div>
        </div>
    </div>
    </div>
    <div id="deleteModal" class="modal">
    <div class="modal-content">
        <p>Are you sure you want to delete this customer?</p>
        <button class="btn btn-danger" id="confirmDelete">Yes</button>
        <button  class="btn btn-primary" id="cancelDelete">No</button>
    </div>
</div>
    <!-- Customer Details -->
    <input type="hidden" id="customerid" value="">
    <div class="customer-name" id="customername">Hapi Bilzs</div>
    <div class="contact-info">
        <a href="#"><img src="images/f7_phone-circle.png" alt=""> &nbsp;&nbsp;<span id="phonenumber"></span></a>
        <a href="#"><img src="images/fa-brands_whatsapp.png" alt=""> &nbsp;&nbsp;<span>WhatsApp</span></a>
    </div>

    <!-- Stats Section -->
    <div class="stats">
        <a href="trans-receive.php?id=<?php echo$id?>">
            <div class="stat-card">
                <div class="img-icon" style="background-color: #FDE6EA">
                    <img src="images/bitcoin-icons_receive-filled.png" alt="">
                </div>
                <div class="stat-text">
                    <div>₹<span id="totalamount">0</span></div>
                    <small>You Receive</small>
                </div>
            </div>
        </a>
        <div class="stat-card">
            <div class="img-icon" style="background-color: #FFF3E3">
                <img src="images/hugeicons_wallet-02.png" alt="">
            </div>
            <div class="stat-text">
                <div>0</div>
                <small>Wallet</small>
            </div>
        </div>
        <div class="stat-card">
            <div class="img-icon" style="background-color: #FFEED9">
                <img src="images/flowbite_shopping-bag-outline.png" alt="">
            </div>
            <div class="stat-text">
                <div id="customerorder">0</div>
                <small>Orders</small>
            </div>
        </div>
        <div class="stat-card">
            <div class="img-icon" style="background-color: #ECF0FC">
                <img src="images/iconamoon_invoice-light.png" alt="">
            </div>
            <div class="stat-text">
                <div id="customerinvoice">0</div>
                <small>Invoices</small>
            </div>
        </div>
        <div class="stat-card">
            <div class="img-icon" style="background-color: #F9EEF0">
                <img src="images/carbon_purchase.png" alt="">
            </div>
            <div class="stat-text">
                <div id="customerpurchase">0</div>
                <small>Purchase Orders</small>
            </div>
        </div>
        <div class="stat-card">
            <div class="img-icon" style="background-color: #FFF6F1">
                <img src="images/teenyicons_cost-estimate-outline.png" alt="">
            </div>
            <div class="stat-text">
                <div id="customerestimate">0</div>
                <small>Estimates</small>
            </div>
        </div>
    </div>

    <!-- Address Section -->
     <div class="addresspart">
        <div class="address-section">
            <h6>Billing Address</h6>
            <div class="address-card">
                <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                <div class="address-text">
                    <h6 id="billname">loading...,</h6>
                    <div id="billphoneno" style="color: #565656;"></div>
                    <div id="billaddress" style="color: #565656;"></div>
                </div>
            </div>
        </div>

        <div class="address-section">
            <h6>Shipping Address</h6>
            <div class="address-card">
                <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                <div class="address-text">
                    <h6 id="shipname">loading...,</h6>
                    <div id="shipphoneno" style="color: #565656;"></div>
                    <div id="shipaddress" style="color: #565656;"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- <script src="toolbar.js"></script> -->

	
	<script src="vendors/scripts/core.js"></script>
	<script src="vendors/scripts/script.min.js"></script>
	<script src="vendors/scripts/process.js"></script>
	<script src="vendors/scripts/layout-settings.js"></script>
	<script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
	<script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
	<!-- buttons for Export datatable -->
	<script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.print.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
	<script src="src/plugins/datatables/js/pdfmake.min.js"></script>
	<script src="src/plugins/datatables/js/vfs_fonts.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
$(document).ready(function () {
    // Function to get query parameter from URL
    function getQueryParam(name) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(name);
    }

    // Fetch orderid from URL
    var Id = getQueryParam('id');

    // Check if orderId is present
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerbyid-api.php',
            method: 'GET',
            data: { id: Id },
            success: function (response) {
                console.log('Full Response:', response);
                var data = typeof response === 'string' ? JSON.parse(response) : response;
                console.log('Parsed Data:', data);

                if (data && Object.keys(data).length > 0) {
                    console.log('Updating values...');
                    
                    // Updating hidden input field
                    $('#customerid').val(data.id);
                    
                    // Updating text content for divs
                    $('#customername').text(data.displayname);
                    $('#phonenumber').text(data.phonenumber);
                    $('#billname').text(data.primarycontact);
                    $('#billphoneno').text(data.phoneno);
                    $('#shipname').text(data.sname);
                    $('#shipphoneno').text(data.sphoneno !== "" ? data.sphoneno : "Not Available"); 

                    // Updating address fields
                    var billingAddress = `${data.address}, ${data.city}, ${data.state ? data.state : ''}, ${data.pincode}`;
                    var shippingAddress = `${data.saddress}, ${data.scity}, ${data.sstate ? data.sstate : ''}, ${data.spincode}`;

                    $('#billaddress').text(billingAddress);
                    $('#shipaddress').text(shippingAddress);
                } else {
                    console.warn('No valid data received.');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error('AJAX error:', textStatus, errorThrown);
            }
        });
    }
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerorder-api.php',
            type: 'GET',  // Changed to GET method
            data: { id:Id }, // Sending filter as query parameter
            dataType: 'json',
			success: function (response) {
					if (response.totalorder !== undefined) { 
						$('#customerorder').text(response.totalorder);
					} else {
						console.error("Error: Invalid response", response);
					}
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerinvoice-api.php',
            type: 'GET',  // Changed to GET method
            data: { id:Id }, // Sending filter as query parameter
            dataType: 'json',
			success: function (response) {
					if (response.totalinvoice !== undefined) { 
						$('#customerinvoice').text(response.totalinvoice);
					} else {
						console.error("Error: Invalid response", response);
					}
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerestimate-api.php',
            type: 'GET',  // Changed to GET method
            data: { id:Id }, // Sending filter as query parameter
            dataType: 'json',
			success: function (response) {
					if (response.totalestimate !== undefined) { 
						$('#customerestimate').text(response.totalestimate);
					} else {
						console.error("Error: Invalid response", response);
					}
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerpurchase-api.php',
            type: 'GET',  // Changed to GET method
            data: { id:Id }, // Sending filter as query parameter
            dataType: 'json',
			success: function (response) {
					if (response.totalpurchase !== undefined) { 
						$('#customerpurchase').text(response.totalpurchase);
					} else {
						console.error("Error: Invalid response", response);
					}
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerdue-api.php',
            type: 'GET',  // Changed to GET method
            data: { id:Id }, // Sending filter as query parameter
            dataType: 'json',
			success: function (response) {
					if (response.totalamount !== undefined) { 
						let totalamount = parseFloat(response.totalamount) || 0; // Ensure it's a float
						$('#totalamount').text(totalamount.toFixed(2)); 
					} else {
						console.error("Error: Invalid response", response);
					}
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
});
$(document).ready(function () {
    var customerId;

    // Open Modal when delete icon is clicked
    $(".delete-btn").click(function () {
        customerId = $(this).data("id"); // Get the customer ID
        $("#deleteModal").show();
    });

    // Cancel Delete
    $("#cancelDelete").click(function () {
        $("#deleteModal").hide();
    });

    // Confirm Delete
    $("#confirmDelete").click(function () {
        $.ajax({
            url: "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/deletecustomer-api.php",
            method: "GET",
            data: { id: customerId },
            success: function (response) {
                console.log("Response Data:", response); // Debugging
                //alert(response.message);
                if (response.success) {
                    window.location.href = "customer.php";
                }
            },
            error: function () {
                alert("Error deleting customer.");
            }
        });

        $("#deleteModal").hide();
    });
});


</script>
</body>
</html>
